#! /bin/sh
toolver=$(grep -n toolver ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
nicknumber=$(grep -n nicknumber ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
fwname=../$(grep -n fwname ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
BMCFIX=$(grep -n BMCFIX ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
setcofg=$(grep -n setcofg ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
forcesoc=$(grep -n forcesoc ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
sdmacchk=x

echo "BMC firmware update tool version $toolver"

# set config
if [ "$1" = "noconfig" ]; then
	setcofg=noconfig
fi

if [ "$1" = "soc" ]; then
	forcesoc=forceon
fi

if [ "$1" = "fix" ]; then
	BMCFIX=FIXBMC
fi

# get file
if [ -f $fwname ]; then
	echo "BMC firmware name:$fwname"
else 
	echo "Can not found $fwname!No souch file exist!"
	exit 0
fi

# yafuflash
if [ $forcesoc != "forceon" ] && [ $BMCFIX != "FIXBMC" ] ; then
	# open virtual device
	./tget 20 c8 aa 01
	sleep 5
	if [ $setcofg = "noconfig" ]; then
		./yafuflash.sh -cd -force-boot $fwname
		if [ "$?" != 0 ]; then
			BMCFIX=FIXBMC
		fi
	else	
		./yafuflash.sh -cd -force-boot -preserve-config $fwname
		if [ "$?" != 0 ]; then
			BMCFIX=FIXBMC
		fi
	fi
fi

# socflash
if [ $forcesoc = "forceon" ] && [ $BMCFIX != "FIXBMC" ] ; then
	echo "BMC reset!"
	#./tget 20 C8 71 01 01 00 01 64 00 03 01
	./tget 20 18 02
	sleep 3
	./socflash.sh -s $fwname 
	if [ "$?" = 255 ]; then
		echo "#############        #####          #########      #####"
		echo "#####              #########          #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "###########      #####   #####        #####        #####"
		echo "#####            #############        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####      #########      #############"

		echo "*******************************************"
		echo "*          Firmware Update fail!!         *"
		echo "*******************************************"
		exit 0
	fi
fi

# fix
if [ $BMCFIX = "FIXBMC" ]; then
	./socflash.sh -s $fwname 
	if [ "$?" = 255 ]; then
		echo "#############        #####          #########      #####"
		echo "#####              #########          #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "###########      #####   #####        #####        #####"
		echo "#####            #############        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####      #########      #############"

		echo "*******************************************"
		echo "*          Firmware Update fail!!         *"
		echo "*******************************************"
		exit 0
	fi
fi

echo "wait 90 seconds"
sleep 90

# ALLDONE
./clrsel
#./tget 20 18 52 05 A0 00 18 01 00 # write EEPROM[18][01] = 00
./tget 20 C8 7F 01
#./tget 20 C8 71 01 01 00 01 64 00 03 01
./setupall.sh

./tget 20 18 02
echo "wait 90 seconds"
sleep 90

# end
echo "BMC need to power off to initial T control function"
echo "press Y to cancel power off system, press others key to power off system."
./YesNo
if [ "$?" = 255 ]; then
	#./tget 20 C8 71 01 01 00 01 64 00 03 01
	./tget 20 00 02 00
fi

#./tget 20 C8 71 01 01 00 01 64 00 03 01

