#! /bin/sh
toolver=$(grep -n toolver ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
nicknumber=$(grep -n nicknumber ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
fwname=../$(grep -n linux_fwname ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
BMCFIX=$(grep -n BMCFIX ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
setcofg=$(grep -n setcofg ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
forcesoc=$(grep -n forcesoc ../config.ini | awk -F'=' '{print $2}' | tr -d '\r\n' )
sdmacchk=x

echo "BMC firmware update tool version $toolver"

# set config
if [ "$1" = "noconfig" ]; then
	setcofg=noconfig
fi

if [ "$1" = "soc" ]; then
	forcesoc=forceon
fi

if [ "$1" = "fix" ]; then
	BMCFIX=FIXBMC
fi

# get file
if [ -f $fwname ]; then
	echo "BMC firmware name:$fwname"
else 
	echo "Can not find $fwname! No such file exists!"
	exit 0
fi


# yafuflash
if [ $forcesoc != "forceon" ] && [ $BMCFIX != "FIXBMC" ] ; then
	sleep 5
	if [ $setcofg = "noconfig" ]; then
		./yafuflash.sh -cd -force-boot $fwname
		if [ "$?" != 0 ]; then
			BMCFIX=FIXBMC
		fi
	else	
		./yafuflash.sh -cd -force-boot -preserve-config $fwname

		if [ "$?" != 0 ]; then
			BMCFIX=FIXBMC
		fi
	fi
fi

# socflash
if [ $forcesoc = "forceon" ] && [ $BMCFIX != "FIXBMC" ] ; then
    echo "Staring SOC flash."
	./socflash.sh -s $fwname 
    echo "SOC flash is done."
	if [ "$?" = 255 ]; then
		echo "#############        #####          #########      #####"
		echo "#####              #########          #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "###########      #####   #####        #####        #####"
		echo "#####            #############        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####      #########      #############"

		echo "*******************************************"
		echo "*          Firmware Update fail!!         *"
		echo "*******************************************"
		exit 0
	fi
fi

# fix
if [ $BMCFIX = "FIXBMC" ]; then
    echo "Staring SOC flash."
	./socflash.sh -s $fwname 
	if [ "$?" = 255 ]; then
        echo "#############        #####          #########      #####"
		echo "#####              #########          #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "###########      #####   #####        #####        #####"
		echo "#####            #############        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####        #####        #####"
		echo "#####            #####   #####      #########      #############"

		echo "*******************************************"
		echo "*          Firmware Update fail!!         *"
		echo "*******************************************"
		exit 0
	fi
fi

echo "wait for 90 seconds"
sleep 90
echo "BMC is ready now"

#Setup all configurations for the project
./setupall.sh

#Set firmware name for display in WebUI
./FWName.sh

# Enable Power Saving mode
./tget 20 c8 aa 01
# end
echo "press Y to cancel power off system, press others key to power off system."
./YesNo
if [ "$?" = 255 ]; then
	./tget 20 00 02 00
fi
